#include "ulamek.cpp"

/*
//Dziedziczenie (klasa pochodna nie jest szablonem)
class ansistring_int_ulamek : public ulamek<int>
    {
    private:
        AnsiString to_AnsiString() const
            {
            return (AnsiString)licznik+'/'+(AnsiString)mianownik;
            }
    public:
    	ansistring_int_ulamek(int alicznik=0,int amianownik=1):ulamek<int>(alicznik,amianownik)
            {
            }
        operator AnsiString()
            {
            return to_AnsiString();
            }
    };
*/

//Dziedziczenie (klasa pochodna jest szablonem)
template <class T>
class ansistring_ulamek : public ulamek<T>
    {
    private:
        AnsiString to_AnsiString() const
            {
            return (AnsiString)licznik+'/'+(AnsiString)mianownik;
            }
    public:
    	ansistring_ulamek(T alicznik=0,T amianownik=1):ulamek<T>(alicznik,amianownik)
            {
            }
        from_ulamek(ulamek<T> aulamek)
            {
            aulamek.get(licznik,mianownik);
            }
        operator AnsiString()
            {
            return to_AnsiString();
            }
    };


//operatory zwracajace obiekt klasy potomnej
template <class T> ansistring_ulamek<T> operator *(const ansistring_ulamek<T>& aulamek1,const ansistring_ulamek<T>& aulamek2)
    {
    ansistring_ulamek<T> as_ulamek;
    as_ulamek.from_ulamek((ulamek<T>)aulamek1*(ulamek<T>)aulamek2);
    return as_ulamek;
    };
template <class T> ansistring_ulamek<T> operator /(const ansistring_ulamek<T>& aulamek1,const ansistring_ulamek<T>& aulamek2)
    {
    ansistring_ulamek<T> as_ulamek;
    as_ulamek.from_ulamek((ulamek<T>)aulamek1/(ulamek<T>)aulamek2);
    return as_ulamek;
    };
template <class T> ansistring_ulamek<T> operator +(const ansistring_ulamek<T>& aulamek1,const ansistring_ulamek<T>& aulamek2)
    {
    ansistring_ulamek<T> as_ulamek;
    as_ulamek.from_ulamek((ulamek<T>)aulamek1+(ulamek<T>)aulamek2);
    return as_ulamek;
    };
template <class T> ansistring_ulamek<T> operator -(const ansistring_ulamek<T>& aulamek1)
    {
    ansistring_ulamek<T> as_ulamek;
    as_ulamek.from_ulamek(-(ulamek<T>)aulamek1);
    return as_ulamek;
    };
template <class T> ansistring_ulamek<T> operator -(const ansistring_ulamek<T>& aulamek1,const ansistring_ulamek<T>& aulamek2)
    {
    ansistring_ulamek<T> as_ulamek;
    as_ulamek.from_ulamek((ulamek<T>)aulamek1-(ulamek<T>)aulamek2);
    return as_ulamek;
    };

